import numpy as np
import matplotlib.pyplot as plt

#factor=1.6343

factor=1.6030


FileName='KJmodel0b'

Y = np.loadtxt(FileName+'-Y.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)-3.0
YJ=Y
J1 = np.loadtxt(FileName+'-J1.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J2 = np.loadtxt(FileName+'-J2.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J3 = np.loadtxt(FileName+'-J3.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J4 = np.loadtxt(FileName+'-J4.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J5 = np.loadtxt(FileName+'-J5.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J6 = np.loadtxt(FileName+'-J6.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J7 = np.loadtxt(FileName+'-J7.rpt',skiprows=3,usecols=(1),dtype='f8',unpack=True)/factor
J1[0]=0
J2[0]=0
J3[0]=0
J4[0]=0
J5[0]=0
J6[0]=0
J7[0]=0

J3mean=np.trapz(J3,x=Y)
J4mean=np.trapz(J4,x=Y)
J5mean=np.trapz(J5,x=Y)
J6mean=np.trapz(J6,x=Y)
J7mean=np.trapz(J7,x=Y)
Jmean=np.mean((J4mean,J5mean,J6mean,J7mean))

#StrJmean=r'$J_{mean}^{3-7}$= %.3f' %(Jmean)
StrJmean=r'Average J-integral: $\bar{J}_{4-7}$= %.3f' %(Jmean)

plt.figure(figsize=(7,5))
plt.plot(J1,(Y-1.)/2.,':b',label='J-integral for contour 1')
plt.plot(J2,(Y-1.)/2.,'-.b',label='J-integral for contour 2-3')
plt.plot(J3,(Y-1.)/2.,'-.b')
plt.plot(J4,(Y-1.)/2.,'-b',label='J-integral for contours 4-7')
plt.plot(J5,(Y-1.)/2.,'-b')
plt.plot(J6,(Y-1.)/2.,'-b')
plt.plot(J7,(Y-1.)/2.,'-b')
plt.plot((Jmean,Jmean),(-0.5,0),'--b',label=StrJmean)
plt.ylabel('z/(2h)',fontsize=18)
plt.xlabel(r'$J(z)/(\varepsilon_{xx} \sigma_{xx} 2h)$',fontsize=18)
plt.legend(loc=2,fontsize=14)
plt.xlim(0,0.4)
plt.ylim(-0.5,0)
#plt.ylim((0,2))
plt.grid()
plt.savefig('FIG9-'+FileName+'-JFig.png')
plt.savefig('FIG9-'+FileName+'-JFig.eps')
plt.show()

